/*
 * LeuraCOMMatrix.c
 *
 * Created: 09.02.2015 18:13:22
 *  Author: Nenninger
 */ 

#define F_CPU 7372800UL 

#include <stdlib.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>



#define BIT(x)(1<<x)

#define LED_STELLEN 128

#define tbi(ADDRESS,BIT) (ADDRESS ^= (1LL<<BIT))	// toggle BIT

// AUSGNGE
#define AUSGABE_PORT     PORTB
#define AUSGABE_REGISTER DDRB
#define STEUER_PORT      PORTD
#define STEUER_REGISTER  DDRD
#define REDLED			 BIT(3)
#define LED_CLOCK        BIT(4)
#define LED_STROBE       BIT(6)
#define LED_OE           BIT(5)

uint8_t ausgabe[LED_STELLEN+1];

const unsigned char N[32] = {255,2,12,48,64,255,0,8,8,8,0,1,1,255,1,1,112,136,136,112,0,56,68,68,56,0,255,0,176,168,72,0};

#define helligkeit OCR0B

int rx_buffer_counter = -1;
int zto = 500;							//Zeichen TimeOut

#define zeichentimeout 30

#define BAUD 115200UL							// Baudrate

// Berechnungen
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD)		// Fehler in Promille, 1000 = kein Fehler.

#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
	#error Systematischer Fehler der Baudrate grsser 1% und damit zu hoch!
#endif

void init_com(void){
	UCSRB = (1<<TXEN)|(1<<RXEN)|(1<<RXCIE);							// UART TX/RX RX Interruppt einschalten
	UCSRC = (0<<UMSEL0) | (0<<UMSEL1) | (1<<UCSZ1) | (1<<UCSZ0);	// Asynchron 8N1
	
	UBRRH = UBRR_VAL >> 8;
	UBRRL = UBRR_VAL & 0xFF;
}

void strobe_led(void)							// Segmente in die Ausgangsregister schreiben
{
	STEUER_PORT |= LED_STROBE;					// Impuls etwas strecken
	STEUER_PORT |= LED_STROBE;
	STEUER_PORT |= LED_STROBE;
	STEUER_PORT |= LED_STROBE;
	STEUER_PORT |= LED_STROBE;
	STEUER_PORT |= LED_STROBE;
	STEUER_PORT &= ~LED_STROBE;
	return;
}

void send_matrix(void)							// Ausgabe in Schieberegister rckwrts!!!
{
	uint8_t n;
	STEUER_PORT &= ~LED_CLOCK;					// auf passiven Pegel bringen
	STEUER_PORT &= ~LED_CLOCK;
	STEUER_PORT &= ~LED_CLOCK;
	STEUER_PORT &= ~LED_CLOCK;
	for(n=0; n<LED_STELLEN; n++) {
		AUSGABE_PORT = 255-ausgabe[n];
		STEUER_PORT |= LED_CLOCK;              // und CLK dazu
		STEUER_PORT |= LED_CLOCK;
		STEUER_PORT |= LED_CLOCK;
		STEUER_PORT |= LED_CLOCK;
		STEUER_PORT |= LED_CLOCK;
		STEUER_PORT &= ~LED_CLOCK;
	}
	strobe_led();
	tbi(PORTD,PD3);
	return;
}

void send_com(char c){
	while(!(UCSRA & (1<<UDRE)));			//Warten solange bis Zeichen gesendet wurde
	UDR = c;								//Ausgabe des Zeichens
	return;
}


ISR(USART_RX_vect){
	char rx_char = UDR;
	zto = zeichentimeout;

	if (rx_buffer_counter < LED_STELLEN){						//wenn Zeichen fr mich
		if(rx_buffer_counter == -1){							//erstes Zeichen als Helligkeit
			helligkeit = rx_char;
			rx_buffer_counter++;
		}else{ 
			ausgabe[rx_buffer_counter++] = rx_char;
			
		}
	}else if (rx_buffer_counter == LED_STELLEN){
		send_com(helligkeit);
		send_com(rx_char);
		rx_buffer_counter++;										//sonst Zeichen weitergeben
	}else{
		send_com(rx_char);										//sonst Zeichen weitergeben
	}

}

ISR (TIMER1_COMPA_vect){
	if(zto > 0) zto--;
	if(zto == 0){
		zto = -1;
		rx_buffer_counter = -1;
		send_matrix();
	}
}

ISR(BADISR_vect){
	STEUER_PORT |= REDLED;
}

void init_led(void)
{
	AUSGABE_PORT = 0x00;
	AUSGABE_REGISTER = 0xFF;
	STEUER_PORT &= ~(REDLED | LED_CLOCK | LED_STROBE | LED_OE); 
	STEUER_REGISTER |= (REDLED | LED_CLOCK | LED_STROBE | LED_OE);
	strobe_led();
}

void init(void){
	ACSR = (1<<ACD);
	
	//Timer0 PWM
	TCCR0A = BIT(COM0B1) | BIT(WGM00);
	TCCR0B = BIT(CS00);

	//Timer1 Timer
	TCCR1A = (1<<WGM01); // CTC Modus
	TCCR1B |= (1<<CS00) | (1<<CS01); // Prescaler 64
	OCR1A = 0x72;
	
	// Compare Interrupt erlauben
	TIMSK |= (1<<OCIE1A);
	
	helligkeit=255;
}

int main(void){
	uint8_t n;
	uint8_t b;
	init();
	init_led();
	for(n = 0; n < LED_STELLEN; n=n+32) {
	   for(b = 0;b < 32;b++){
		   ausgabe[b+n] = N[b];
	   }
	}
	send_matrix();
	for(b = 0;b<20;b++){
		_delay_ms(250);
	}
	for(n = 0; n < LED_STELLEN; n++) {
		for(b = LED_STELLEN;b>0;b--){
			ausgabe[b] = ausgabe[b-1];
		}
		
		send_matrix();	
		_delay_ms(50);
	}
	for(b = 0;b<20;b++){
		_delay_ms(250);
	}
	ausgabe[0]=0;	
	for(n = 0; n < LED_STELLEN; n++) {
		for(b = LED_STELLEN;b>0;b--){
			ausgabe[b] = ausgabe[b-1];
		}
		
		send_matrix();
		_delay_ms(10);
	}
	
	init_com();
	sei();
	while(1) {
		;
	}
	return(0);
}