#include <avr/io.h>
#include "adc.h"

uint32_t adc_read(uint8_t mux)
{
  uint16_t i;
  uint32_t result = 0;         //Initialisieren wichtig, da lokale Variablen
                               //nicht automatisch initialisiert werden und
                               //zufllige Werte haben. Sonst kann Quatsch rauskommen
  ADCSRA = (1<<ADEN) | (1<<ADPS2) |(0<<ADPS1) | (1<<ADPS0);    // Frequenzvorteiler 
                               // setzen auf 32 (1) und ADC aktivieren (1)
 
  ADMUX = mux;                      // Kanal waehlen
  ADMUX &=~ (1<<REFS0); // VCC(5V) als Referenzspannung nutzen 
 
  /* nach Aktivieren des ADC wird ein "Dummy-Readout" empfohlen, man liest
     also einen Wert und verwirft diesen, um den ADC "warmlaufen zu lassen" */
  ADCSRA |= (1<<ADSC);              // eine ADC-Wandlung 
  while ( ADCSRA & (1<<ADSC) ) {
     ;     // auf Abschluss der Konvertierung warten 
  }
 
  /* Eigentliche Messung - Mittelwert aus 256 aufeinanderfolgenden Wandlungen */
  for(i=0;i<256;i++)
  {
    ADCSRA |= (1<<ADSC);            // eine Wandlung "single conversion"
    while ( ADCSRA & (1<<ADSC) ) {
      ;   // auf Abschluss der Konvertierung warten
    }
    result += ADCW;		    // Wandlungsergebnisse aufaddieren
  }
  ADCSRA &= ~(1<<ADEN);             // ADC deaktivieren (2)
 
  result /= 256;                     // DW: Summe durch 16 teilen = 14-bit
 
  return result;
}
