/*
 * TempHell.c
 *
 * Created: 12.03.2012 13:09:22
 *  Author: Nenninger
 */ 

#define F_CPU 7372800UL
#define BAUD 38400UL

// Berechnungen Baudrate
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD) // Fehler in Promille, 1000 = kein Fehler.
 
#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error  Systematischer Fehler in der Baudrate grsser 1% und damit zu hoch!
#endif

/*Includes*/
#include <avr/io.h>
//#include <stdio.h>
#include <stdlib.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <string.h>

#define messinterval 1024	//Messinterval in ms

volatile unsigned char rs; //Helligkeit aus Array(LUX)
volatile uint16_t rr;  // gemessener Luxwert
volatile unsigned char e; //Empfindlichkeit Lux Sensor
volatile unsigned int messzeit=0;
volatile unsigned char p0,p1,p2; //ADC obenren 8 Bit des 10Bit Ergebnis
volatile unsigned char eingaenge; //Eingangsstatus

volatile unsigned int wait=0; //Zhler kein Zeichen vom Master (offline)
volatile unsigned char waitmess; //Wartezeit nach umschalten des Sensors

uint16_t lux[256] = {3,7,12,24,32,42,54,66,80,96,112,130,150,170,192,216,240,266,294,322,352,384,416,450,486,522,560,600,640,682,726,770,816,864,912,962,1014,1066,1120,1176,1232,1290,1350,1410,1472,1536,1600,1666,1734,1802,1872,1944,2016,2090,2166,2242,2320,2400,2480,2562,2646,2730,2816,2904,2992,3082,3174,3266,3360,3456,3552,3650,3750,3850,3952,4056,4160,4266,4374,4482,4592,4704,4816,4930,5046,5162,5280,5400,5520,5642,5766,5890,6016,6144,6272,6402,6534,6666,6800,6936,7072,7210,7350,7490,7632,7776,7920,8066,8214,8362,8512,8664,8816,8970,9126,9282,9440,9600,9760,9922,10086,10250,10416,10584,10752,10922,11094,11266,11440,11616,11792,11970,12150,12330,12512,12696,12880,13066,13254,13442,13632,13824,14016,14210,14406,14602,14800,15000,15200,15402,15606,15810,16016,16224,16432,16642,16854,17066,17280,17496,17712,17930,18150,18370,18592,18816,19040,19266,19494,19722,19952,20184,20416,20650,20886,21122,21360,21600,21840,22082,22326,22570,22816,23064,23312,23562,23814,24066,24320,24576,24832,25090,25350,25610,25872,26136,26400,26666,26934,27202,27472,27744,28016,28290,28566,28842,29120,29400,29680,29962,30246,30530,30816,31104,31392,31682,31974,32266,32560,32856,33152,33450,33750,34050,34352,34656,34960,35266,35574,35882,36192,36504,36816,37130,37446,37762,38080,38400,38720,39042,39366,39690,40016,40344,40672,41002,41334,41666,42000,42336,42672,43010,43350,43690,50000,80000};

#define sbi(ADDRESS,BIT) (ADDRESS |= (1<<BIT))
#define cbi(ADDRESS,BIT) (ADDRESS &= ~(1<<BIT))

#define led_an()      ( PORTD |=  ( 1 << PD5 ) )
#define led_aus()     ( PORTD &= ~( 1 << PD5 ) )

//Master
#define mcommaxlen 5 // Maximale Zeichen anzahl

volatile struct {
	unsigned fertig:1; //Daten empfangen (entweder maxstrlen oder Zeichen Timeout erreicht
	unsigned warte:1; // warte auf Zeichen
	unsigned anzahl:6; //Anzahl der Empfangenen Zeichen
       }
mcom;

volatile char mcom_str[mcommaxlen]=""; //Empfangene Zeichen
char mcom_rcv[mcommaxlen]="";	//Empfangene Zeichen zum weiterarbeiten

volatile unsigned char mcom_rt; //Zhler Zeichen Timeout (RXD)

void mcom_init(void)
{
	UCSRB = (1<<TXEN)|(1<<RXEN)|(1<<RXCIE);			// UART TX/RX RX Interruppt einschalten
	UCSRC = (1<<URSEL) | (1<<UCSZ1) | (1<<UCSZ0);	// Asynchron 8N1 
 
	UBRRH = UBRR_VAL >> 8;
	UBRRL = UBRR_VAL & 0xFF;
}

char mdowaitsendcomplet(void){
	//while (!(UCSR1A & (1<<TXC1))){}
	loop_until_bit_is_set(UCSRA, TXC);
	//UCSRA = (1<<TXC);
	//_delay_us(250);
	//_delay_us(250);
	PORTD &= ~(1 << PD2); //schalte MAX485 auf empfangen
	return 0;
}


// sende ein Char zum Master
int msendc(char c)
{
    loop_until_bit_is_set(UCSRA,UDRE);	/* warten bis Senden moeglich */
    UDR = c;								/* sende Zeichen */
    return 0;
}

// dem Master einen ganzen String senden
void msend(char data[],unsigned char len)
{
	unsigned char count;
  
	PORTD |= (1 << PD2); //schalte MAX485 auf senden
	cli();
	for (count = 0; count < len; count++){
		msendc(data[count]);
	}
	UCSRA = (1<<TXC);
	sei();
	mdowaitsendcomplet();
}

void msendnc(char data)
{
  
	PORTD |= (1 << PD2); //schalte MAX485 auf senden

	msendc(data);

	mdowaitsendcomplet();
}

void setsensor(unsigned char c){
	switch(c){
		case 0:
			PORTC &= ~(1 << PC4);
			PORTC &= ~(1 << PC5);
		break;
		case 1:
			PORTC &= ~(1 << PC5);
			PORTC |= (1 << PC4);
		break;
		case 2:
			PORTC &= ~(1 << PC4);
			PORTC |= (1 << PC5);
		break;
		case 3:
			PORTC |= (1 << PC4);
			PORTC |= (1 << PC5);
		break;
	}
	messzeit = messinterval;
	waitmess=200;
	

}

uint32_t get_adc(unsigned char p){
	uint32_t result;

	ADMUX = 0;
	switch(p){
		case 0:
			ADMUX |= (1<<REFS0) | (1<<ADLAR) ;				//PC0 fr messungen verwenden
		break;
		case 1:
			ADMUX |= (1<<REFS0) | (1<<MUX0) | (1<<ADLAR) ;	//PC1 fr messungen verwenden
		break;
		case 2:
			ADMUX |= (1<<REFS0) | (1<<MUX1) | (1<<ADLAR) ;	//PC2 fr messungen verwenden
		break;
		case 3:
			ADMUX |= (1<<REFS0) | (1<<MUX0) | (1<<MUX1) ;	//PC3 fr messungen verwenden
		break;			
	}
  	ADCSRA = (1<<ADEN) | (1<<ADPS2) | (1<<ADPS1)| (1<<ADPS0);
 
  	/* nach Aktivieren des ADC wird ein "Dummy-Readout" empfohlen, man liest
     	also einen Wert und verwirft diesen, um den ADC "warmlaufen zu lassen" */
  	ADCSRA |= (1<<ADSC);              				// eine ADC-Wandlung 
  	while ( ADCSRA & (1<<ADSC) );     				// auf Abschluss der Konvertierung warten 
  	result = ADCH;  // ADCW muss einmal gelesen werden, sonst wird Ergebnis der nchsten Wandlung nicht bernommen.
 
  	/* Eigentliche Messung - Mittelwert aus 4 aufeinanderfolgenden Wandlungen */
  	result = 0; 
   	for(char i=0; i<100; i++ )
  	{
		ADCSRA |= (1<<ADSC);            // eine Wandlung "single conversion"
    	while ( ADCSRA & (1<<ADSC) );   // auf Abschluss der Konvertierung warten
    	if(p==3){
			result += ADCL;        // Wandlungsergebnisse aufaddieren
  			result += (ADCH<<8);
		}else{
			result += ADCH;
		}		    		// Wandlungsergebnisse aufaddieren
  	}
  	ADCSRA &= ~(1<<ADEN);             	// ADC deaktivieren
 
  	result /= 100;                     	// Summe durch vier teilen = arithm. Mittelwert
 
	return result;
    
}

ISR(USART_RXC_vect){
	unsigned char buffer;
    mcom_rt = 0;

	buffer = UDR;							// Daten aus dem Puffer lesen
	if ( mcom.fertig==0 ){					// wenn  gerade nicht in Verarbeitung
    	mcom.warte = 1;
		if (mcom.anzahl < mcommaxlen-1){	// wenn nicht maximal Anzahl
			mcom_str[mcom.anzahl]=buffer;	// Zeichen an den String anhngen
			mcom.anzahl++;
								// Anzahl der Zeichen + 1
		} else {
			mcom_str[mcom.anzahl]=buffer;
			mcom.fertig=1;
			mcom.warte = 0;
		}
	}
	
}

void machemessung(void){
	uint32_t r;
	unsigned char pr0,pr1,pr2;
	
	r = get_adc(3);

	if(((r)>1020)&(e>0)){
		e--;
		setsensor(e);
		r = get_adc(3);
	}
	if(((r)>1020)&(e>0)){
		e--;
		setsensor(e);
		r = get_adc(3);
	}
	if(((r)>1020)&(e>0)){
		e--;
		setsensor(e);
		r = get_adc(3);
	}
	if(((r)<10)&(e<3)){
		e++;
		setsensor(e);
		r = get_adc(3);
	}
	if(((r)<10)&(e<3)){
		e++;
		setsensor(e);
		r = get_adc(3);
	}
	if(((r)<10)&(e<3)){
		e++;
		setsensor(e);
		r = get_adc(3);
	}


	pr0 = get_adc(0);
	pr1 = get_adc(1);
	pr2 = get_adc(2);

	rr = r;

	p0 = pr0;
	p1 = pr1;
	p2 = pr2;
    
	uint64_t i=0;
	
	if(e==0){
		i = (1000 * (uint64_t)rr);
	}
	if(e==1){
		i = (100 * (uint64_t)rr);
	}
	if(e==2){
		i = (10 * (uint64_t)rr);
	}
	if(e==3){
		i = (1 * (uint64_t)rr);
	}
	
	rs = 0;
	unsigned char b = 0;
	while(1){
		if((i < lux[b])|(b==255)){
			rs = b;
			break;
		}
		b++;
	}

	
}

//Timer Interupt
ISR(TIMER0_OVF_vect){
	//setze damit ein Umlauf ~ 1ms ist
	TCNT0 = 248;
  
	if(mcom.warte == 1){	//warte auf Zeichen
		mcom_rt++;			//dann Zhler Timeout Zeichen +1
	}

  
	if(mcom_rt == 20){		//Timeout Zeichen (RXD) dann String zum weiterverarbeiten geben
		mcom.warte = 0;
		mcom_rt = 0;
		mcom.fertig=1;
		
	}
	wait++;
	if(wait==3000){
		wait=0;
		led_an();
	}
	
	if(waitmess>0){
		waitmess--;
	}
	
	if((messzeit==0)){
		messzeit = messinterval;
		//machemessung();
	}else if(waitmess==0){
		messzeit--;
	}
}



void mantwort(void){
	//Eingnge abfragen
	if(!( PINB & (1<<PB1))){
		sbi(eingaenge,0);
	}else{
		cbi(eingaenge,0);
	}
	if(!( PINB & (1<<PB2))){
		sbi(eingaenge,1);
	}else{
		cbi(eingaenge,1);
	}
	char cmd[8];

	cmd[0] = 254;
	cmd[1] = 2;
	cmd[2] = rs;//Helligkeit	
	cmd[3] = p2;//Temperatur
	cmd[4] = p0;//frei ADC0 =PC0
	cmd[5] = p1;//frei ADC1 =PC1
	cmd[6] = eingaenge;
	cmd[7] = '*';
	msend(cmd,8);
	machemessung();
}

void init(void){
	
	/* Beschreibung der ein und Ausgnge
		
	PC0= <- ADC0 *frei
	PC1= <- ADC1	 *frei
	PC2= <- ADC2 Temperatur
	PC3= <- ADC3	 Helligkeit
	PC4= -> Umschaltung Empfindlichkeit Luxsensor
	PC5= -> Umschaltung Empfindlichkeit Luxsensor
	PC6= <- !RESET

	PB0= <- *frei
	PB1= <- Kellerfenster
	PB2= <- *frei EINGANG!!!
	PB3= <- !ISP
	PB4= <- !ISP
	PB5= <- !ISP
	PB6= <- !Quarz
	PB7= <- !Quarz

	PD0= !RX
	PD1= !TX
	PD2= -> MAX Umschaltung
	PD3= -> *frei
	PD4= -> *frei
	PD5= -> rote LED
	PD6= -> *frei
	PD7= -> *frei

	*/
	
	//ANA_COMP ausschalten;
	ACSR = (1<<ACD);
	// Timer 0 konfigurieren
    TCCR0 |= (1<<CS00) | (1<<CS02); // Prescaler 1024
    // Compare Interrupt erlauben
    TIMSK |= (1<<TOIE0);
	//Ausgnge
	DDRD |= (1 << PD2);
	DDRD |= (1 << PD5);
	DDRC |= (1 << PC4);
	DDRC |= (1 << PC5);
	
	//interne Pullups
	PORTB |= (1<<PB1)|(1<<PB2);
	
	eingaenge=0;
	
	e = 0;
	setsensor(e);
	mcom_init();
	sei();

}

//unbehandelte Interrupt
ISR(BADISR_vect){
	led_an();
}

int main(void){
	led_an();
	init();
	while(1){
		if(mcom.fertig==1){	
			unsigned char len;
			len = mcom.anzahl;
			mcom.anzahl = 0;
			memcpy(mcom_rcv,mcom_str,len);	//Daten zum weiterarbeiten kopieren
			mcom.fertig=0;
			if(mcom_rcv[0]==0xff){								//Polling
				if(mcom_rcv[1]==2){			// wenn eigene Adresse 
					led_aus();
					wait=0;
					mantwort();
				}
			}
		}
	}
 	return 0;
}
