#define F_CPU 7372800UL 

#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include <string.h>
#include <avr/pgmspace.h>
#include <util/delay.h>

#define BAUD 38400UL      // Baudrate

#define E0 1
#define E1 2
#define E2 4
#define E3 8
#define E4 16
#define E5 32
#define E6 64
#define E7 128

volatile struct {
	unsigned statustor:1; //Status Tor
	unsigned statusgtor:1; //Status Garagentor
	unsigned licht:2; // letzte funktion Licht
	unsigned aenderung:1;
	unsigned isthell:1;
    }
automatik;

volatile unsigned char helligkeit_ist = 70;
volatile unsigned char tueren;

volatile unsigned char tt_e1;

volatile struct {
	unsigned e1:1; //Taster 1
    }
taster;

// Berechnungen
#define UBRR_VAL ((F_CPU+BAUD*8)/(BAUD*16)-1)   // clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))     // Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUD) // Fehler in Promille, 1000 = kein Fehler.
 
#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate grsser 1% und damit zu hoch! 
#endif 

#define mcommaxlen 10 // Maximale Zeichen anzahl

volatile struct {
	unsigned fertig:1; //Daten empfangen (entweder maxstrlen oder Zeichen Timeout erreicht
	unsigned warte:1; // warte auf Zeichen
	unsigned anzahl:6; //Anzahl der Empfangenen Zeichen
       }
mcom;

char mcom_str[mcommaxlen]=""; //Empfangene Zeichen
char mcom_rcv[mcommaxlen]="";	//Empfangene Zeichen zum weiterarbeiten

volatile unsigned int mcom_rt; //Zhler Zeichen Timeout (RXD)

volatile unsigned int msek; //Zhler Zeichen Timeout (RXD)

void mcom_init(void)
{
	UCSRB = (1<<TXEN)|(1<<RXEN)|(1<<RXCIE);			// UART TX/RX RX Interruppt einschalten
	UCSRC = (0<<UMSEL) | (1<<UCSZ1) | (1<<UCSZ0);	// Asynchron 8N1 
 
	UBRRH = UBRR_VAL >> 8;
	UBRRL = UBRR_VAL & 0xFF;
}

char mdowaitsendcomplet(void){
	//while (!(UCSR1A & (1<<TXC1))){}
	loop_until_bit_is_set(UCSRA, TXC);
	//UCSRA = (1<<TXC);
	//_delay_us(500);
	PORTD &= ~(1 << PD2); //schalte MAX485 auf empfangen
	return 0;
}


// sende ein Char zum Master
int msendc(char c)
{
    loop_until_bit_is_set(UCSRA,UDRE);	/* warten bis Senden moeglich */
    UDR = c;								/* sende Zeichen */
    return 0;
}

// dem Master einen ganzen String senden
void msend(char data[],unsigned char len)
{
	unsigned char count;
  
	PORTD |= (1 << PD2); //schalte MAX485 auf senden
	cli();
	for (count = 0; count < len; count++){
		msendc(data[count]);
	}
	UCSRA = (1<<TXC);
	sei();
	mdowaitsendcomplet();
}

void msendnc(char data)
{
  
	PORTD |= (1 << PD2); //schalte MAX485 auf senden
	cli();
	msendc(data);
	UCSRA = (1<<TXC);
	sei();
	mdowaitsendcomplet();
}

void an(char r){
	PORTD |= (1 << (r+2));
}
void aus(char r){
	PORTD &= ~(1 << (r+2));
}
void toggeln(char r){
	r += 2;
	PORTD ^= (1<<r);
}


ISR(USART_RX_vect)
{
	unsigned char buffer;
    mcom_rt = 0;
	
	buffer = UDR;							// Daten aus dem Puffer lesen
	if ( mcom.fertig==0 ){					// wenn  gerade nicht in Verarbeitung
    mcom.warte = 1;
		if (mcom.anzahl < mcommaxlen-1){	// wenn nicht maximal Anzahl
			mcom_str[mcom.anzahl]=buffer;	// Zeichen an den String anhngen
			mcom.anzahl++;
								// Anzahl der Zeichen + 1
		} else {
			mcom_str[mcom.anzahl]=buffer;
			mcom.fertig=1;
			mcom.warte = 0;
		}
	}

}

ISR (TIMER0_COMPA_vect)
{
	msek++;
	if(msek==1000){
		
		msek=0;
	}
	if(mcom.warte == 1){	//warte auf Zeichen
		mcom_rt++;			//dann Zhler Timeout Zeichen +1
	}

  
	if(mcom_rt == 20){		//Timeout Zeichen (RXD) dann String zum weiterverarbeiten geben
		mcom.warte = 0;
		mcom_rt = 0;
		mcom.fertig=1;
		
	}
	if(tt_e1>0){
		tt_e1--;
	}
}

void mantwort(void){
	char cmd[8];

	cmd[0] = 254;
	cmd[1] = 5;
	cmd[2] = PORTD;	
	cmd[3] = helligkeit_ist;
	cmd[4] = automatik.statusgtor;
	cmd[5] = automatik.statustor;
	cmd[6] = tueren;
	cmd[7] = '*';

	msend(cmd,8);
	
}

void init(void) {

	/*
	PA0=Quarz
	PA1=Quarz
	PA2=RESET!!!
	PB0=E1
	PB1=E2
	PB2=E3
	PB3=E4
	PB4=E5
	PB5=ISP
	PB6=ISP
	PB7=ISP
	PD0=RXD
	PD1=TXD
	PD2=Max Umschaltung
	PD3=R1
	PD4=R2
	PD5=R3
	PD6=R4+300mA
	*/

	DDRA = 0xFF;
	DDRB = 0xFF;
	DDRD = 0xFF;


	//Eingnge definieren
	//DDRA &= ~ ((1<<PA0) | (1<<PA1));
	DDRB &= ~ ((1<<PB0) | (1<<PB1) | (1<<PB2) | (1<<PB3) | (1<<PB4));

	//interne Pullups
	PORTB |= (1<<PB0) | (1<<PB1) | (1<<PB2) | (1<<PB3) | (1<<PB4);

	
	//Ausgnge auf HI
	//PORTB |= (1 << PB0);
	//PORTB |= (1 << PB1);
	//PORTB |= (1 << PB2);
	//PORTB |= (1 << PB3);

	//Ausgnge auf LOW	
	//PORTB &= ~(1 << PB4);
	//PORTB &= ~(1 << PB5);

	//ANA_COMP ausschalten;
	ACSR = (1<<ACD);
	
	mcom_init();

	// Timer 0 konfigurieren
    TCCR0A = (1<<WGM01); // CTC Modus
    TCCR0B |= (1<<CS00) | (1<<CS01); // Prescaler 64
    OCR0A = 0x72;
 
    // Compare Interrupt erlauben
    TIMSK |= (1<<OCIE0A);

	PORTD &= ~(1 << PD2); //schalte MAX485 auf empfangen
	mcom.fertig=0;
    
	sei();
}





void mbefehleauswerten(char len){
	unsigned char r,f,count;
	for (count = 2; count < len; count=count+2){
		r = mcom_rcv[count];						//Wer?
		f = mcom_rcv[count+1];						//Was?
		switch(r){
			case 1: case 2: case 3: case 4:
				switch(f){								//einzeln
					case 1:
						an(r);
					break;
					case 2:
						aus(r);
					break;
				}
				
			break;
		}
	}
}


int main(void) {
	init();
	
	while(1){
		if(mcom.fertig==1){	
			unsigned char len;
			len = mcom.anzahl;
			mcom.anzahl = 0;
			//msend(mcom_rcv,mcom.anzahl);
			
			memcpy(mcom_rcv,mcom_str,len);	//Daten zum weiterarbeiten kopieren

			mcom.fertig=0;
			if(mcom_rcv[0]==0xff){								//Polling
				if(mcom_rcv[1]==5){			// wenn eigene Adresse 
					if(len>2){									//wenn lnger als 2 dann steht was im Telegramm
						mbefehleauswerten(len);
					}
					mantwort();
				}
			}
			if(mcom_rcv[0]==0xfe){								//Antwort Slave
				if(mcom_rcv[1]==2){								//Adresse 2 -> Helligkeit und Temperatur
					if(mcom_rcv[2] != helligkeit_ist){
						helligkeit_ist = mcom_rcv[2];
						//helligkeit_ist = 2;
						if((helligkeit_ist > 1)&(automatik.isthell==0)){
							automatik.aenderung = 1;
							automatik.isthell=1;
						}
						if((helligkeit_ist < 1)&(automatik.isthell==1)){
							automatik.aenderung = 1;
							automatik.isthell=0;
						}
					}
				}
				if(mcom_rcv[1]==3){								//Adresse 3 -> Tor
					if((mcom_rcv[3]==2)&(mcom_rcv[4]==2)){
						if(automatik.statustor != 0){
							automatik.statustor = 0;
							automatik.aenderung = 1;
						}

					}else{
						if(automatik.statustor != 1){
							automatik.statustor = 1;
							automatik.aenderung = 1;
						}
					}
				}
				if(mcom_rcv[1]==4){								//Adresse 4 -> Tren
					if(mcom_rcv[2] != tueren){
						tueren = mcom_rcv[2];
						automatik.statusgtor = ((tueren & 0x10) == 0x10);
						automatik.aenderung = 1;
					}
					
				}
			}
		}
		//Beleuchtung an?

		if(automatik.aenderung == 1){
			if(automatik.isthell){
				aus(4);
				aus(1);
				aus(2);
				an(3);
			}else{
				if((automatik.statusgtor==1)|(automatik.statustor==1)){
					an(4);
				}else{
					aus(4);
				}
				an(1);
				aus(3);
			}
		}
		automatik.aenderung = 0;
		//Taster1
		if ((!(( PINB & E0 ) == E0 ))&(tt_e1==0)&(taster.e1==0)) {
			taster.e1=1;
			toggeln(2);
			tt_e1=200;
			
		}
		if((( PINB & E0 ) == E0 )){
			taster.e1=0;
		}
	}   
	return 0;
	
}

