/*
 * Steuerung.c
 *
 * Created: 05.03.2012 15:19:39
 *  Author: Nenninger
 */ 


#define F_CPU 7372800UL 

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdlib.h>
#include <string.h>

#define pwmstart 30
#define pwmlangsam 10
#define pwmzeit 30
#define maxstrom 550
#define maxstromerhoehung 110
#define zeitzumlangsam 1			//in sekunden
#define zeitmotornacheinander 1500
#define zeittorzu 180				//in sekunden
#define zeittorzukurz 20			//in sekunden
#define zeitabschalten 10			// in sekunden
#define zeitwartefalschauf 3		// in sekunden
#define zeitgaragenrelaisanzug 500	



volatile unsigned int mwait;
volatile unsigned char ms_taster;
volatile unsigned int ms_ledtor;
volatile unsigned char s_abschalten;
volatile unsigned int ms;
volatile unsigned int ms_pwm;
volatile unsigned int ms_zmn;
volatile unsigned int s_torzu;
volatile unsigned int s_wartefalschauf;
volatile unsigned int ms_gra;
volatile unsigned int s_gesamttimeout;


volatile struct {
	unsigned ls:1; 			// 1 Bit LichtschrankenStatus
	unsigned torled:3;		// LampenStatus
	unsigned gehistauf:1;	// 1 Bit Gehflgel ist auf
	unsigned gehistzu:1;	// 1 Bit Gehflgel ist zu
	unsigned standistauf:1;	// 1 Bit Standflgel ist auf
	unsigned standistzu:1;	// 1 Bit Standflgel ist zu
	unsigned abschalten:1;	// 1 Bit Tor abschalten
	unsigned start:1;
	unsigned sendmasterantwort:1;
	unsigned gistauf:1;
	unsigned sistauf:1;
} status;

volatile struct {					
	unsigned stand:3; 				// fr Stand Motorfunktion
	unsigned geh:3; 				// fr Geh Motorfunktion
	unsigned stand_langsam_sek:4;	// Zeit in sekunden bis langsam gemacht wird
	unsigned geh_langsam_sek:4;		// Zeit in sekunden bis langsam gemacht wird
	unsigned stand_langsam:1;
	unsigned geh_langsam:1;
} motor;

volatile struct {
	unsigned ls:1;
	unsigned geh:3;
	unsigned stand:3;
	unsigned steuerung:4;
}
statusanmaster;

volatile struct {
	unsigned auf:1; 	
	unsigned zu:1; 
	unsigned stop:1;
	unsigned geh:1;  
	unsigned gehgarage:1;
	unsigned aufTOR:2;  
	unsigned zuTOR:2; 
} taster;

volatile struct {
	unsigned auf:1; 	
	unsigned zu:1; 
	unsigned stop:1;
	unsigned geh:1;  
	unsigned gehgarage:1;
	unsigned aufTOR:1;  
	unsigned zuTOR:1; 
} tasteralt;

volatile struct {
	unsigned auf:1; 	
	unsigned zu:1; 
	unsigned stop:1;
	unsigned geh:1;  
} befmaster;

volatile struct {
	unsigned geh:3; 	
	unsigned stand:3; 
} step;

volatile unsigned char aufTORcount;
volatile unsigned char zuTORcount;

//L298 geh enable
#define geh_enable()      ( PORTD |=  ( 1 << PD2 ) )
#define geh_disable()     ( PORTD &= ~( 1 << PD2 ) )

//L298 stand enable
#define stand_enable()    ( PORTD |=  ( 1 << PD3 ) )
#define stand_disable()   ( PORTD &= ~( 1 << PD3 ) )

//rote LED
#define ledan()    ( PORTD |=  ( 1 << PD7 ) )
#define ledaus()   ( PORTD &= ~( 1 << PD7 ) )

//LED's Tor
#define ledtoran()    ( PORTD |=  ( 1 << PD6 ) )
#define ledtoraus()   ( PORTD &= ~( 1 << PD6 ) )

//Garage
#define garagean()    ( PORTE |=  ( 1 << PE0 ) )
#define garageaus()   ( PORTE &= ~( 1 << PE0 ) )

//Netzteil
#define netzan()    ( PORTE |=  ( 1 << PE1 ) )
#define netzaus()   ( PORTE &= ~( 1 << PE1 ) )

//adc Werte
volatile uint16_t adcgeh;
volatile uint16_t adcstand;
volatile uint16_t adcgehalt;
volatile uint16_t adcstandalt;

#define BAUDAD 2400UL			// Baudrate ADC
#define BAUDMaster 38400UL		// Baudrate Master

// Berechnungen Baudrate ADC
#define UBRR_VAL ((F_CPU+BAUDAD*8)/(BAUDAD*16)-1)			// clever runden
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))					// Reale Baudrate
#define BAUD_ERROR ((BAUD_REAL*1000)/BAUDAD)				// Fehler in Promille, 1000 = kein Fehler.
 
#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate ADC nicht genau!!!! 
#endif 

#define UBRR_VALM ((F_CPU+BAUDMaster*8)/(BAUDMaster*16)-1)	// clever runden
#define BAUD_REALM (F_CPU/(16*(UBRR_VALM+1)))				// Reale Baudrate
#define BAUD_ERRORM ((BAUD_REALM*1000)/BAUDMaster)			// Fehler in Promille, 1000 = kein Fehler.
 
#if ((BAUD_ERROR<990) || (BAUD_ERROR>1010))
  #error Systematischer Fehler der Baudrate Master nicht genau!!!! 
#endif 

//AD-Wandler
#define adcommaxlen 7										// Maximale Zeichen anzahl

volatile struct {
	unsigned fertig:1;										//Daten empfangen (entweder maxstrlen oder Zeichen Timeout erreicht
	unsigned warte:1;										// warte auf Zeichen
	unsigned anzahl:6;										//Anzahl der Empfangenen Zeichen
} adcom;

//Empfangene Zeichen
volatile char adcom_str[adcommaxlen]=""; 
//Empfangene Zeichen zum weiterarbeiten
char adcom_rcv[adcommaxlen]="";	

volatile unsigned int adcom_rt;								//Zhler Zeichen Timeout (RXD)

//UART0 (ADC) initialisieren
void adccom_init(void){
	UCSR0B = (1<<RXEN0)|(1<<RXCIE0);						// UART RX und RX Interruppt einschalten
	UCSR0C = (1<<URSEL0) | (1<<UCSZ01) | (1<<UCSZ00);		// Asynchron 8N1 
	UBRR0H = UBRR_VAL >> 8;
	UBRR0L = UBRR_VAL & 0xFF;
}

//Master
#define mmaxlen 4											// Maximale Zeichen anzahl

volatile struct {
	unsigned fertig:1;										//Daten empfangen (entweder maxstrlen oder Zeichen Timeout erreicht
	unsigned warte:1;										// warte auf Zeichen
	unsigned anzahl:6;										//Anzahl der Empfangenen Zeichen
} mcom;

//Empfangene Zeichen
volatile char mcom_str[mmaxlen]=""; 
//Empfangene Zeichen zum weiterarbeiten
char mcom_rcv[mmaxlen]="";	

volatile unsigned int mcom_rt;								//Zhler Zeichen Timeout (RXD)

//UART1 (Master) initialisieren
void mcom_init(void){
	UCSR1B = (1<<TXEN1)|(1<<RXEN1)|(1<<RXCIE1);				// UART TX/RX RX Interruppt einschalten
	UCSR1C = (1<<URSEL1) | (1<<UCSZ11) | (1<<UCSZ10);		// Asynchron 8N1 
 
	UBRR1H = UBRR_VALM >> 8;
	UBRR1L = UBRR_VALM & 0xFF;
}

void mdowaitsendcomplet(void){
	loop_until_bit_is_set(UCSR1A, TXC1);
	//UCSR1A = (1<<TXC1);
	//_delay_us(250);
	PORTB &= ~(1 << PB1);									//schalte MAX485 auf empfangen
}

// sende ein Char zum Master
int msendc(char c){
    loop_until_bit_is_set(UCSR1A,UDRE1);					/* warten bis Senden moeglich */
    UDR1 = c;												/* sende Zeichen */
    return 0;
}

// dem Master einen ganzen String senden
void msend(char data[],unsigned char len){
	unsigned char count;
  
	PORTB |= (1 << PB1);									//schalte MAX485 auf senden
	cli();
	for (count = 0; count < len; count++){
		msendc(data[count]);
	}
	
	//msendc(data[count]);
	UCSR1A = (1<<TXC1);
	sei();
	mdowaitsendcomplet();
}

void mantwort(void){
	/*char cmd[20];
	utoa( adcgeh, cmd, 10 ); 
	msend(cmd,4);
	utoa( adcstand, cmd, 10 ); 
	msend(cmd,4);
	cmd[0]=PINA;
	cmd[1]=PINC;
	cmd[2]=OCR1A;
	cmd[3]=OCR1B;
	cmd[4]=OCR3A;
	cmd[5]=OCR3B;
	cmd[6]=motor.geh;
	cmd[7]=motor.stand;
	cmd[8]=motor.geh_langsam_sek;
	cmd[9]=motor.stand_langsam_sek;
	cmd[10]=s_abschalten;
	cmd[11]=statusanmaster.ls;
	cmd[12]=statusanmaster.geh;
	cmd[13]=statusanmaster.stand;
	cmd[14]=statusanmaster.steuerung;
	cmd[15]=step.geh;
	cmd[16]=step.stand;
	cmd[17]=s_torzu;
	msend(cmd,18);*/
	char cmd[7];
	cmd[0]=0xFE;
	cmd[1]=0x03;
	cmd[2]=statusanmaster.ls;
	cmd[3]=statusanmaster.geh;
	cmd[4]=statusanmaster.stand;
	cmd[5]=statusanmaster.steuerung;
	cmd[6]=0x00;
	msend(cmd,7);
}

// Netzteil und L298 einschalten
void machstroman(char was){
	status.abschalten = 0;
	s_abschalten = 0;
	netzan();
	switch(was){
		case 1:
			geh_enable();
		break;
		case 2:
			stand_enable();
		break;
	}
	s_gesamttimeout = 45;	
}

//Timer0 ca 1ms
ISR (TIMER0_COMP_vect){
	//Timeout Zeichen ADC
	if(adcom.warte == 1){
		adcom_rt++;
	}
	if(adcom_rt == 20){
		adcom.warte = 0;
		adcom_rt = 0;
		adcom.fertig=1;
	}
	//Timeout Zeichen Master
	if(mcom.warte == 1){
		mcom_rt++;
	}
	if(mcom_rt == 30){
		mcom.warte = 0;
		mcom_rt = 0;
		mcom.fertig=1;
	}
	//Master Timeout
	mwait++;
	if(mwait==3000){
		mwait=0;
		ledan();
	}
	//Verzgerung ffnung Standflgel 
	if(ms_zmn>0){
		ms_zmn--;
		if(ms_zmn==0){
			step.stand = 1;
		}
	}
	//alle Sekunden
	ms++;
	if(ms==1000){
		ms=0;
		if(s_gesamttimeout > 0){
			s_gesamttimeout--;
			if(s_gesamttimeout==0){
				geh_disable();
				stand_disable();
				netzaus();
			}
		}
		//Geh langsamer werden
		if(motor.geh_langsam_sek > 0){
			motor.geh_langsam_sek--;
			if(motor.geh_langsam_sek==0){
				motor.geh_langsam = 1;
			}
		}
		//Stand langsamer werden
		if(motor.stand_langsam_sek > 0){
			motor.stand_langsam_sek--;
			if(motor.stand_langsam_sek==0){
				motor.stand_langsam = 1;
			}
		}
		//Netzteil und L298 abschalten
		if(s_abschalten>0){
			s_abschalten--;
			if(s_abschalten==0){
				status.abschalten = 1;
				geh_disable();
				stand_disable();
				netzaus();
				s_gesamttimeout = 0;
			}
		}
		//Tor wieder schlieen		
		if(s_torzu>0){
			s_torzu--;
			if(s_torzu==0){
				step.geh = 4;
				step.stand = 4;
			}
			if((status.torled == 0)|(status.torled == 4)){
				if(s_torzu>10){
					status.torled = 4;
				}else{
					status.torled = 2;
				}
			}			
		}
		//warte Zeit bis Geh ffnen wenn falsch zu
		if(s_wartefalschauf>0){
			s_wartefalschauf--;
			if(s_wartefalschauf==0){
				step.geh = 1;
			}			
		}
		//Start wird nach 1 Sekunde zurckgesetzt
		status.start = 0;	
	}	
	//Abfall Garagen Relais	
	if(ms_gra>0){
		ms_gra--;
		if(ms_gra==0){
			garageaus();
		}
	}
	//Taster	
	ms_taster++;
	if(ms_taster==50){
		ms_taster=0;
		//AUF
		if(!(( PINC & (1<<PC0)))) {
			if((!taster.auf)&(!tasteralt.auf)){
				tasteralt.auf = 1;
			}else{
				if((!taster.auf)&(tasteralt.auf)){
					taster.auf = 1;
				}
			}
		}else{
			taster.auf = 0;
			tasteralt.auf = 0;
		}	
		//ZU
		if(!(( PINC & (1<<PC1)))) {
			if((!taster.zu)&(!tasteralt.zu)){
				tasteralt.zu = 1;
			}else{
				if((!taster.zu)&(tasteralt.zu)){
					taster.zu = 1;
				}
			}
		}else{
			taster.zu = 0;
			tasteralt.zu = 0;
		}		
		//STOP
		if(!(( PINC & (1<<PC2)))) {
			if((!taster.stop)&(!tasteralt.stop)){
				tasteralt.stop = 1;
			}else{
				if((!taster.stop)&(tasteralt.stop)){
					taster.stop = 1;
				}
			}
		}else{
			taster.stop = 0;
			tasteralt.stop = 0;
		}	
		//GEH
		if(!(( PINC & (1<<PC3)))) {
			if((!taster.geh)&(!tasteralt.geh)){
				tasteralt.geh = 1;
			}else{
				if((!taster.geh)&(tasteralt.geh)){
					taster.geh = 1;
				}
			}
		}else{
			taster.geh = 0;
			tasteralt.geh = 0;
		}
		//GEHGARAGE
		if(!(( PINC & (1<<PC4)))) {
			if((!taster.gehgarage)&(!tasteralt.gehgarage)){
				tasteralt.gehgarage = 1;
			}else{
				if((!taster.gehgarage)&(tasteralt.gehgarage)){
					taster.gehgarage = 1;
				}
			}
		}else{
			taster.gehgarage = 0;
			tasteralt.gehgarage = 0;
		}
		//amTorAUF
		if(!(( PINC & (1<<PC7)))) {
			if((!taster.aufTOR)&(!tasteralt.aufTOR)){
				tasteralt.aufTOR = 1;
			}else{
				if((!taster.aufTOR)&(tasteralt.aufTOR)){
					taster.aufTOR = 1;
				}
				if((tasteralt.aufTOR)){
					aufTORcount++;
					if(aufTORcount>=40){
						taster.aufTOR = 2;
						aufTORcount=0;
					}
				}
													
			}
		}else{
			taster.aufTOR = 0;
			tasteralt.aufTOR = 0;
			aufTORcount=0;
		}
		//amTorZU
		if(!(( PINC & (1<<PC6)))) {
			if((!taster.zuTOR)&(!tasteralt.zuTOR)){
				tasteralt.zuTOR = 1;
			}else{
				if((!taster.zuTOR)&(tasteralt.zuTOR)){
					taster.zuTOR = 1;
				}
				if((tasteralt.zuTOR)){
					zuTORcount++;
					if(zuTORcount>=40){
						taster.zuTOR = 2;
						zuTORcount=0;
					}
				}
													
			}
		}else{
			taster.zuTOR = 0;
			tasteralt.zuTOR = 0;
			zuTORcount=0;
		}
																
        
	}//ende Taster	
	
	//LED Anzeigen am Tor
	if(status.torled>0){
		ms_ledtor++;
	}else{
    	ms_ledtor = 0;
		ledtoraus();
	}
	switch(status.torled){
		//Motor luft
		case 1:
			switch(ms_ledtor){
				case 1: case 250: case 500: case 750:
					ledtoran();
				break;
				case 100: case 350: case 600:
					ledtoraus();
				break;
			}
			if(ms_ledtor >= 1150){
				ms_ledtor = 0;
			}
		break;
		//Zeit automatisch zu  kleiner 10 Sekunden
		case 2:
			switch(ms_ledtor){
				case 1:
					ledtoran();
				break;
				case 500:
					ledtoraus();
				break;
			}
			if(ms_ledtor >= 1000){
				ms_ledtor = 0;
			}
		break;
		//Stopp erkannt
		case 3:
			switch(ms_ledtor){
				case 1:
					ledtoran();
				break;
				case 101:
					ledtoraus();
				break;
			}
			if(ms_ledtor >= 201){
				ms_ledtor = 0;
			}
		break;
		//Zeit automatisch zu luft
		case 4:
			ledtoran();
		break;
	}
	//Motorsteuerung
	ms_pwm++;
	if(ms_pwm==pwmzeit){
		ms_pwm = 0;
		switch(motor.geh){
			case 0: //stop
				OCR1A = 0;
				OCR1B = 0;
				motor.geh_langsam_sek = 0;
				motor.geh_langsam = 0;
			break;
			case 1: //soll auf
				if(OCR1B==0){
					if(OCR1A==0){
						OCR1A = pwmstart;
						machstroman(1);
					}else{
						if(OCR1A<200){
							OCR1A++;
						}				
					}
				}else{
					OCR1B -= 5;
					if(OCR1B<=10){
						OCR1B = 0;
					}	
				}				
			break;
			case 2: //soll zu
				if(OCR1A==0){
					if(OCR1B==0){
						OCR1B = pwmstart;
						machstroman(1);
					}else{
						if((motor.geh_langsam==0)){
							if(OCR1B<150){
								OCR1B++;
							}
							if((OCR1B==255)&(motor.geh_langsam_sek==0)){
								motor.geh_langsam_sek = zeitzumlangsam;
							}					
						}
						if(motor.geh_langsam==1){
							if(OCR1B>pwmlangsam){
								OCR1B--;
							}
						}
					}
				}else{
					OCR1A -= 5;
					if(OCR1A<=10){
						OCR1A = 0;
					}	
				}					
			break;
			case 3: //auslaufen auf
				if(OCR1A>30){
					OCR1A-=6;
				}else{
					OCR1A=0;
					motor.geh = 0;
				}
			break;
			case 4: //auslaufen zu
				if(OCR1B>30){
					OCR1B-=4;
				}else{
					OCR1B=0;
					motor.geh = 0;
				}
			break;
			
		}
		switch(motor.stand){
			case 0: //stop
				OCR3A = 0;
				OCR3B = 0;
				motor.stand_langsam_sek = 0;
				motor.stand_langsam = 0;
			break;
			case 1: //soll auf
				if(OCR3B==0){
					if(OCR3A==0){
						OCR3A = pwmstart;
						machstroman(2);
					}else{
						if(OCR3A<200){
							OCR3A++;
						}				
					}
				}else{
					OCR3B -= 5;
					if(OCR3B<=10){
						OCR3B = 0;
					}	
				}
			break;
			case 2: //soll zu
				if(OCR3A==0){
					if(OCR3B==0){
						OCR3B = pwmstart;
						machstroman(2);
					}else{
						if((motor.stand_langsam==0)){
							if(OCR3B<150){
								OCR3B++;
							}
							if((OCR3B==255)&(motor.stand_langsam_sek==0)){
								motor.stand_langsam_sek = zeitzumlangsam;
							}					
						}
						if(motor.stand_langsam==1){
							if(OCR3B>pwmlangsam){
								OCR3B--;
							}
						}
					}
				}else{
					OCR3A -= 5;
					if(OCR3A<=10){
						OCR3A = 0;
					}	
				}	
			break;
			case 3: //auslaufen auf
				if(OCR3A>40){
					OCR3A-=6;
				}else{
					OCR3A=0;
					motor.stand = 0;
				}
			break;
			case 4: //auslaufen zu
				if(OCR3B>30){
					OCR3B-=4;
				}else{
					OCR3B=0;
					motor.stand = 0;
				}
			break;
			
		}
	}//ende PWM
}//ende Timer

//Zeichen vom ADC Empfangen
ISR(USART0_RXC_vect){
	unsigned char buffer;
    adcom_rt = 0;
	buffer = UDR0;							// Daten aus dem Puffer lesen
	if ( adcom.fertig==0 ){					// wenn  gerade nicht in Verarbeitung
		adcom.warte = 1;
		if (adcom.anzahl < adcommaxlen-1){	// wenn nicht maximal Anzahl
			adcom_str[adcom.anzahl]=buffer;	// Zeichen an den String anhngen
			adcom.anzahl++;					// Anzahl der Zeichen + 1
		} else {
			adcom_str[adcom.anzahl]=buffer;
			adcom.fertig=1;
			adcom.warte = 0;
		}
	}
}

//Zeichen vom Master Empfangen
ISR(USART1_RXC_vect){
	unsigned char buffer;
    mcom_rt = 0;
	
	buffer = UDR1;							// Daten aus dem Puffer lesen
	if ( mcom.fertig==0 ){					// wenn  gerade nicht in Verarbeitung
		mcom.warte = 1;
		if (mcom.anzahl < mmaxlen-1){		// wenn nicht maximal Anzahl
			mcom_str[mcom.anzahl]=buffer;	// Zeichen an den String anhngen
			mcom.anzahl++;					// Anzahl der Zeichen + 1
		} else {
			mcom_str[mcom.anzahl]=buffer;
			mcom.fertig=1;
			mcom.warte = 0;
		}
	}
}

//erstmal alles in was definiertes bringen
void init(void) {
	
	/* Beschreibung der ein und Ausgnge
	PA0	-< Geh ist auf 
	PA1 -< Geh ist zu
	PA2 -< Stand ist auf
	PA3 -< Stand ist zu
	PA4 -< 
	PA5 -< 
	PA6 -< 
	PA7 -< 
	
	PC0	-< AUF
	PC1 -< ZU
	PC2 -< STOP
	PC3 -< Geh
	PC4 -< Geh+Garage
	PC5 -< LS
	PC6 -< am Tor AUF
	PC7 -< am Tor ZU
	
	
	PB0= -> Clock Attiny13 (AD-Wandler)
	PB1= Master RS485 (enable)
	PB2= Master RS485
	PB3= Master RS485
	PB4= -> PWM Stand zu
	
	PB5-7 ISP

	PD0=AD-Wandler RX
	PD1=AD-Wandler TX
	PD2= -> Geh Enabled
	PD3= -> Stand Enabled 

	PD4= -> PWM Stand auf
	PD5= -> PWM Geh auf
	PD6= -> LED's
	PD7= -> rote LED Master Offline
	
	PE0= -> Garage auf
	PE1= -> Netzteil ein
	PE2= -> PWM Geh zu	

	*/
	
	//Eingang Interrupps abschalten
	GICR=0x00;

	//Alles als Eingnge definieren
	DDRA = 0x00;
	DDRB = 0x00;
	DDRC = 0x00;
	DDRD = 0x00;
	DDRE = 0x00;
	
	//Ausgnge
	DDRB |= (1<<PB1)|(1<<PB4);
	DDRD |= (1<<PD2)|(1<<PD3)|(1<<PD4)|(1<<PD5)|(1<<PD6)|(1<<PD7);
	DDRE |= (1<<PE0)|(1<<PE1)|(1<<PE2);

	//interne Pullups
	PORTA = 0xff;
	PORTC = 0xff;
	//PORTD |= (1<<PD0) | (1<<PD1) | (1<<PD2);
	//PORTE |= (1<<PE0) | (1<<PE1) | (1<<PE2);

	//Ausgnge auf HI
	//PORTB |= (1 << PB2);

	//ANA_COMP ausschalten;
	ACSR |= (1<<ACD);
	

	// Timer 0 konfigurieren
		// Prescaler 64 CTC
		TCCR0 |= (1<<CS00) | (1<<CS01) | (1<<WGM01);	
		// ca 1ms
		OCR0 = 0x72;
		// Compare Interrupt erlauben									
		TIMSK |= (1<<OCIE0);							
	

	//PWM init Geh;
		TCCR1B |= (1<<CS12); 
		TCCR1A |= (1<<WGM10);
		TCCR1B |= (1<<WGM12);
		TCCR1A |= (1<<COM1A1) | (1<<COM1B1) ;	
		OCR1A =	0;
		OCR1B = 0;
	//PWM init Stand
		TCCR3B |= (1<<CS32); 
		TCCR3A |= (1<<WGM30);
		TCCR3B |= (1<<WGM32);
		TCCR3A |= (1<<COM3A1) | (1<<COM3B1) ;	
		OCR3A =	0;
		OCR3B = 0;
	
	mcom_init();
	adccom_init();
	status.start = 1;
	s_abschalten = 1;
	s_torzu = 0;
	sei();
}

//unbehandelte Interrupt
ISR(BADISR_vect){
	ledan();
}

void stoppetorzuzeit(void){
	if((status.gehistzu)&(status.standistzu)){
		s_torzu = 0;
		status.torled = 0;
	}
}

//Befehle auswerten
void mbefehleauswerten(char was){
	//auf zu geh stop
	switch(was){
		case 1:
			befmaster.auf = 1;	
		break;
		case 2:
			befmaster.zu = 1;
		break;
		case 3:
			befmaster.geh = 1;
		break;
		case 4:
			befmaster.stop = 1;
		break;
	}
}

void stop (void){
	motor.stand = 0;
	motor.geh = 0;
	step.geh = 0;
	step.stand = 0;
	ms_zmn=0;
	s_torzu=0;
	s_wartefalschauf=0;
	if((status.gehistzu)&(status.standistzu)){
		status.torled = 0;
		step.geh = 6;
		step.stand = 6;
	}else{
		status.torled = 3;
		step.geh = 0;
		step.stand = 0;
	}
}

int main(void)
{
    init();
	ledtoran();
	while(1){
						
		//Taster Stop
		if((taster.stop)){
			stop();			
		}
		
		//LS
		status.ls = !!(( PINC & (1<<PC5)));
		//Geh ist auf
		status.gehistauf = !(( PINA & (1<<PA0)));	
		//Geh ist zu
		status.gehistzu = !(( PINA & (1<<PA1)));	
		//Stand ist auf
		status.standistauf = !(( PINA & (1<<PA2)));	
		//Stand ist zu
		status.standistzu = !(( PINA & (1<<PA3)));		
		
		if(status.start==1){
			if((status.gehistzu)){
				step.geh = 6;
			}
			if((status.gehistauf)){
				step.geh = 3;
			}
			if((status.standistzu)){
				step.stand = 6;
			}
		
			if((status.gehistauf)){
				step.stand = 3;
			}
			if((step.geh==0)&(step.stand==0)){
				status.torled = 3;
			}
			
		}else{
			unsigned char len;
			//Daten vom AD-Wandler?
			if(adcom.fertig==1){				
				len = adcom.anzahl;
				adcom.anzahl = 0;
				memcpy(adcom_rcv,adcom_str,len);
				adcom.fertig=0;
				if((adcom_rcv[0]=='[') & (adcom_rcv[5]==']')){
					adcstand = ((adcom_rcv[2] << 8 ) | adcom_rcv[1]);
					adcgeh   = ((adcom_rcv[4] << 8 ) | adcom_rcv[3]);
					
					if((adcstand>adcstandalt+maxstromerhoehung)|(adcstand>maxstrom)){
						OCR1A = 0;
						OCR1B = 0;
						OCR3A = 0;
						OCR3B = 0;
						statusanmaster.stand=7;
						step.stand=7;
						step.geh=7;
						status.torled = 3;
						motor.geh = 0;
						motor.stand =0;
					}
					if((adcgeh>adcgehalt+maxstromerhoehung)|(adcgeh>maxstrom)){
						OCR1A = 0;
						OCR1B = 0;
						OCR3A = 0;
						OCR3B = 0;
						statusanmaster.geh=7;
						step.stand=7;
						step.geh=7;
						status.torled = 3;
						motor.geh =0;
						motor.stand =0;
					}
					adcstandalt = adcstand;
					adcgehalt = adcgeh;
				}
			}
			//Daten vom Master?
			if(mcom.fertig==1){				
				len = mcom.anzahl;
				mcom.anzahl = 0;
				memcpy(mcom_rcv,mcom_str,len);
				mcom.fertig=0;
				if(mcom_rcv[0]==0xff){
					if(mcom_rcv[1]==3){				// wenn eigene Adresse 
						mwait = 0;
						ledaus();
						if(len>2){					//wenn lnger als 2 dann steht was im Telegramm
							mbefehleauswerten(mcom_rcv[2]);
						}
						status.sendmasterantwort=1;
					}
				}
			}
			
			if(befmaster.stop){
				stop();
			}			
			
			//Funktionen
			if((motor.geh==0)&(motor.stand==0)&(status.abschalten==0)&(s_abschalten==0)){
				s_abschalten = zeitabschalten;
			}
			//????
			//Tor zu nach Zeit
			if((!status.gehistzu)&(s_torzu==0)&(step.geh>0)&(step.stand>0)){
				s_torzu = zeittorzu+1;
			}
			if((s_torzu>0)&(status.ls)){
				s_torzu = zeittorzukurz+1;
			}
			
			//Garage ffnen
			if(taster.gehgarage){
				garagean();
				ms_gra=zeitgaragenrelaisanzug;
			}
			
			//STEP  0= stop 1= sollffnen 2= ffnet 3= offen         4= sollzu        5=schliesst 6= zu
			//MOTOR 0= stop 1= laufauf    2=laufzu  3= auslaufen auf 4= auslaufen zu
			switch(step.geh){
				case 0: case 7:
					if(step.geh==0){
						statusanmaster.stand=6;
						if((taster.auf)|(taster.aufTOR)|(taster.geh)|(taster.gehgarage)|(befmaster.auf)|(befmaster.geh)){step.geh = 1;}
						if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.geh = 4;}
					}					
				break;
				case 1:
					if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.geh = 4;}
					if((!status.gehistauf)&(!status.gistauf)){
						motor.geh = 1;
						status.torled = 1;
						if(!status.gehistzu){
							step.geh++;
							statusanmaster.geh=3;
						}
					}else{
						step.geh=3;
					}										
				break;
				case 2:
					if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.geh = 4;}
					if(status.gehistauf){
						motor.geh = 3;
						step.geh++;
						status.torled = 0;
						status.gistauf = 1;
					}
			
				break;
				case 3:
					if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.geh = 4;}
					statusanmaster.geh=4;
				break;
				case 4:
					status.gistauf = 0;
					if((taster.auf)|(taster.aufTOR)|(taster.geh)|(taster.gehgarage)|(befmaster.auf)|(befmaster.geh)){step.geh = 1;}
					if(!status.gehistzu){
						motor.geh = 2;
						status.torled = 1;
						if(!status.gehistauf){
							step.geh++;
							statusanmaster.geh=5;
						}
					}else{
						step.geh=6;
					}
					if(status.ls){
						step.geh = 1;
					}					
				break;
				case 5:
					if((taster.auf)|(taster.aufTOR)|(taster.geh)|(taster.gehgarage)|(befmaster.auf)|(befmaster.geh)){step.geh = 1;}
					if(status.gehistzu){
						motor.geh = 0;
						step.geh++;
						status.torled = 0;
						//prfen ob stand zuerst zu
						if(!status.standistzu){
							step.stand = 1;
							s_wartefalschauf = zeitwartefalschauf;
						}
					}
					if(status.ls){
						step.geh = 1;
					}
				break;
				case 6:
					if((taster.auf)|(befmaster.auf)){
						if(step.stand > 3){
							ms_zmn = zeitmotornacheinander;
						}	
						step.geh = 1;				
					}
					if((taster.geh)|(taster.gehgarage)|(taster.aufTOR)|(befmaster.geh)){
						step.geh = 1;				
					}
					stoppetorzuzeit();
					statusanmaster.geh=2;
					if(motor.geh > 0){
						motor.geh=0;
					}
				break;
				
			}
			switch(step.stand){
				case 0: case 7:
					if(step.stand==0){
						if(((taster.auf)|(taster.aufTOR==2)|(befmaster.auf))&!(status.gehistzu)){step.stand = 1;}	
						if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.stand = 4;}
						statusanmaster.stand=6;
					}					
				break;
				case 1:
				    if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.stand = 4;}
					if((!status.standistauf)&(!status.sistauf)){
						motor.stand = 1;
						status.torled = 1;
						if(!status.standistzu){
							step.stand++;
							statusanmaster.stand=3;
						}
					}else{
						step.stand=3;
					}					
				break;
				case 2:
					if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.stand = 4;}
					if(status.standistauf){
						motor.stand = 3;
						step.stand++;
						status.torled = 0;
						status.sistauf = 1;
					}
			
				break;
				case 3:
					if(((taster.zu)|(taster.zuTOR)|(befmaster.zu))&(!status.ls)){step.stand = 4;}
					statusanmaster.stand=4;
				break;
				case 4:
					status.sistauf = 0;
					if(((taster.auf)|(taster.aufTOR==2)|(befmaster.auf))&!(status.gehistzu)){step.stand = 1;}
					if(!status.standistzu){
						motor.stand = 2;
						status.torled = 1;
						if(!status.standistauf){
							step.stand++;
							statusanmaster.stand=5;
						}
					}else{
						step.stand=6;
					}
					if(status.ls){
						step.stand = 1;
					}
				break;
				case 5:
				   if(((taster.auf)|(taster.aufTOR==2)|(befmaster.auf))&!(status.gehistzu)){step.stand = 1;}	
					if(status.standistzu){
						motor.stand = 0;
						step.stand++;
					}
					if(status.ls){
						step.stand = 1;
					}
				break;
				case 6:
					if(((taster.auf)|(taster.aufTOR==2)|(befmaster.auf))&!(status.gehistzu)){step.stand = 1;}					
					stoppetorzuzeit();
					statusanmaster.stand=2;
					if(motor.stand > 0){
						motor.stand=0;
					}
				break;
			}		
		
			//Masterdaten setzen
			//LS
			statusanmaster.ls = status.ls;
			//Steuerung
			if(s_torzu>0){
				if(s_torzu>zeittorzukurz){
					statusanmaster.steuerung = 10;
				}else{
					statusanmaster.steuerung = 9;
				}
			}else{
				statusanmaster.steuerung = 8;
			}
			
			//Masterbefehle zurcksetzen
			befmaster.auf = 0;	
			befmaster.zu = 0;
			befmaster.geh = 0;
			befmaster.stop = 0;
			
			//muss ich dem Master eine Antowrt schicken?
			if(status.sendmasterantwort){
				status.sendmasterantwort=0;
				mantwort();
			}
		}//ende nicht start		
		
		
    }
	return 0;
}
