/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    RS232 Routinen

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/
#include "config.h"
#include "usart.h"
#include "stack.h"

#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>
#include <avr/io.h>
#include "rs485.h"
#include <util/delay.h>

	
//volatile unsigned int buffercounter = 0;

char usart_rx_buffer[BUFFER_SIZE];
//char *rx_buffer_pointer_in	= &usart_rx_buffer[0];
//char *rx_buffer_pointer_out	= &usart_rx_buffer[0];
	
//----------------------------------------------------------------------------
//Init serielle Schnittstelle
void usart_init(unsigned long baudrate) 
{ 
	//Serielle Schnittstelle 1
  	//Enable TXEN im Register UCR TX-Data Enable
	UCR =(1 << TXEN | 1 << RXEN | 1<< RXCIE);
	// 0 = Parity Mode Disabled
	// 1 = Parity Mode Enabled, Even Parity
	// 2 = Parity Mode Enabled, Odd Parity
	//UCSRC = 0x06 + ((parity+1)<<4);
	//UCSRC |= (1<<USBS);
	//Teiler wird gesetzt 
	UBRR=(F_CPU / (baudrate * 16L) - 1);
}

//----------------------------------------------------------------------------

//Routine fr die Serielle Ausgabe eines Zeichens (Schnittstelle0)
void usart_write_c(char c)
{
    //Warten solange bis Zeichen gesendet wurde
    while(!(USR & (1<<UDRE)));
    //Ausgabe des Zeichens
    UDR0 = c;
    return;
}


//Ausgabe eines Strings
void usart_write_s(char data[],unsigned char len)
{
	PORTD |= (1 << PD2); //schalte MAX485 auf senden
	unsigned char count;
	cli();
	for (count = 0; count < len; count++)
	{
		usart_write_c(data[count]);
	}
	UCSR0A = (1<<TXC0);
	sei();
	loop_until_bit_is_set(UCSR0A, TXC0);
	//_delay_us(168);
	
	PORTD &= ~(1 << PD2); //schalte MAX485 auf empfangen
}

void usart_write_nc(char c)
{
    PORTD |= (1 << PD2); //schalte MAX485 auf senden
	//Warten solange bis Zeichen gesendet wurde
    cli();
	while(!(USR & (1<<UDRE)));
      //Ausgabe des Zeichens
      UDR = c;
    
	UCSR0A = (1<<TXC0);
	sei();
	loop_until_bit_is_set(UCSR0A, TXC0);
	PORTD &= ~(1 << PD2); //schalte MAX485 auf empfangen

    return;
}

//----------------------------------------------------------------------------
//Empfang eines Zeichens

ISR (USART_RX)
{
		unsigned char receive_char;
		receive_char = (UDR);
		
		mcom_rt = 0;
		
		mwait = 0;		//Pollingtimeout deaktivieren
	
		if (mcom.fertig)
		{
			return; 
		}
        
	
		if (mbuffercounter < BUFFER_SIZE - 1){
			mcom.warte = 1; //Timer fr Zeichen Timeout
			m_rx_buffer[mbuffercounter++] = receive_char;    
		}
		
	
	return;
}



