/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    Webserver Applikation

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/
#include "config.h"
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "stack.h"
#include "base64.h"
#include "analog.h"
#include "timer.h"
#include "usart.h"
//#include "telnetd.h"

#include "httpd.h"
#include "webpage.h"
#include "ntp.h"
#include "rs485.h"
#include "ftexte.h"

struct http_table http_entry[MAX_TCP_ENTRY];

unsigned char doreload = 0;

//Hier wird das codierte Passwort aus config.h gespeichert.
unsigned char http_auth_passwort[30];

unsigned char post_in[5] = {'O','U','T','='};
unsigned char post_ready[5] = {'S','U','B','='};
char dstr[24]={"---"};

char steuerbefehl[10]={"---"};
char steuerbefehlstart[5] = {'?','s','t','='};

//----------------------------------------------------------------------------
//Variablenarry zum einfgen in Webseite %VA@00 bis %VA@09
//unsigned int var_array[MAX_VAR_ARRAY] = {10,50,30,0,0,0,0,0,0,0};
//----------------------------------------------------------------------------
//<meta http-equiv="refresh" content="0;  URL=http://www.computerhilfen.de">
PROGMEM char http_reloadst[]={"<meta http-equiv=\"refresh\" content=\"1; URL=http://192.168.20.252/st.htm\">"};
PROGMEM char http_reloadeg[]={"<meta http-equiv=\"refresh\" content=\"1; URL=http://192.168.20.252/eg.htm\">"};
PROGMEM char http_reloadog[]={"<meta http-equiv=\"refresh\" content=\"1; URL=http://192.168.20.252/og.htm\">"};

//TEXT_PLAIN
PROGMEM char http_header0[]={	"HTTP/1.1 200 OK\r\n"
								"Server: AVR-Web\r\n"
								"Content-Type: text/plain\r\n\r\n"};
//TEXT_HTML
PROGMEM char http_header1[]={	"HTTP/1.1 200 OK\r\n"
								"Server: AVR-Web\r\n"
								"Content-Type: text/html\r\n\r\n"};
//TEXT_HTML_AUTH
PROGMEM char http_header2[]={	"HTTP/1.1 401 Unauthorized\r\n"
								"Server: AVR-Web\r\n"
								"WWW-Authenticate: Basic realm=\"NeedPassword\""
								"\r\nContent-Type: text/html\r\n\r\n"};
//IMAGE_JPEG
PROGMEM char http_header3[]={	"HTTP/1.1 200 OK\r\n"
								"Server: AVR-Web\r\n"
								"Cache-Control: max-age=6000000\r\n"
								"Content-Type: image/jpeg\r\n\r\n"};
//IMAGE_GIF						
PROGMEM char http_header4[]={	"HTTP/1.1 200 OK\r\n"
								"Server: AVR-Web\r\n"
								/*"Last-Modified: Fri, 08 Jul 2008 16:48:29 GMT"*/
								"Cache-Control: max-age=6000000\r\n"
								/*"Expires: Fri, 08 Jul 2010 16:48:29 GMT"*/
								"Content-Type: image/gif\r\n\r\n"};
//TEXT_CSS						
PROGMEM char http_header5[]={	"HTTP/1.1 200 OK\r\n"
								"Server: AVR-Web\r\n"
								/*"Last-Modified: Fri, 08 Jul 2008 16:48:29 GMT"*/
								"Cache-Control: max-age=6000000\r\n"
								/*"Expires: Fri, 08 Jul 2010 16:48:29 GMT"*/
								"Content-Type: text/css\r\n\r\n"};



//----------------------------------------------------------------------------
//Kein Zugriff Seite bei keinem Passwort
PROGMEM char Page0[] = {"401 Unauthorized%END"};

unsigned char rx_header_end[5] = {"\r\n\r\n\0"};


//----------------------------------------------------------------------------
//Initialisierung des Httpd Testservers
void httpd_init (void)
{
	//HTTP_AUTH_STRING 
	decode_base64((unsigned char*)HTTP_AUTH_STRING,http_auth_passwort);

	//Serverport und Anwendung eintragen
	add_tcp_app (HTTPD_PORT, (void(*)(unsigned char))httpd);
}
   
//----------------------------------------------------------------------------
//http Testserver
void httpd (unsigned char index)
{
    //Verbindung wurde abgebaut!
    if (tcp_entry[index].status & FIN_FLAG)
    {
        return;
    }

	//Allererste Aufruf des Ports fr diese Anwendung
	//HTTPD_Anwendungsstack lschen
	if(tcp_entry[index].app_status==1)
	{
		httpd_stack_clear(index);
	}
	
	//HTTP wurde bei dieser Verbindung zum ersten mal aufgerufen oder
	//HTML Header Retransmission!
	if (tcp_entry[index].app_status <= 2)
	{	
		httpd_header_check (index);
		return;
	}
	
	//Der Header wurde gesendet und mit ACK besttigt (tcp_entry[index].app_status+1)
	//war das HTML Packet fertig, oder mssen weitere Daten gesendet werden, oder Retransmission?
	//if (tcp_entry[index].app_status > 2 && tcp_entry[index].app_status < 0xFFFE)
	if (tcp_entry[index].app_status > 2 && tcp_entry[index].app_status < 0xFFFE && tcp_entry[index].status == ACK_FLAG)
	{
		httpd_data_send (index);
		return;
	}
	
	//Verbindung kann geschlossen werden! Alle HTML Daten wurden gesendet TCP Port kann
	//geschlossen werden (tcp_entry[index].app_status >= 0xFFFE)!!
	if (tcp_entry[index].app_status >= 0xFFFE)
	{
		tcp_entry[index].app_status = 0xFFFE;
		tcp_Port_close(index);
		return;
	}
	return;
}

//----------------------------------------------------------------------------
//HTTPD_STACK lschen
void httpd_stack_clear (unsigned char index)
{
	http_entry[index].http_header_type = TEXT_HTML;
	http_entry[index].first_switch = 0;
	http_entry[index].http_auth = HTTP_AUTH_DEFAULT;
	http_entry[index].new_page_pointer = 0;
	http_entry[index].old_page_pointer = 0;
	http_entry[index].post = 0;
	http_entry[index].auth_ptr = http_auth_passwort;
	http_entry[index].post_ptr = post_in;
	http_entry[index].post_ready_ptr = post_ready;
	http_entry[index].hdr_end_pointer = rx_header_end;			
	//HTTP_DEBUG("\r\n**** NEUE HTTP ANFORDERUNG ****\r\n\r\n");
	return;
}

//----------------------------------------------------------------------------
//Eintreffenden Header vom Client checken
void httpd_header_check (unsigned char index)
{
	unsigned int a = 0;
	unsigned int c = 0;
	
	if(strcasestr_P((char*)&eth_buffer[TCP_DATA_START_VAR],PSTR("POST"))!=0)
		{
		http_entry[index].post = 1;
		}
	
	
	//finden der Authorization und das Ende im Header auch ber mehrere Packete hinweg!!	
	if(*http_entry[index].hdr_end_pointer != 0)
	{		
		for(a=TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
		{	
			//HTTP_DEBUG("%c",eth_buffer[a]);
			
			if(!http_entry[index].http_auth) 
			{
				if (eth_buffer[a] != *http_entry[index].auth_ptr++)
				{
					http_entry[index].auth_ptr = http_auth_passwort;
				}
				if(*http_entry[index].auth_ptr == 0) 
				{
					http_entry[index].http_auth = 1;
					//HTTP_DEBUG("  <---LOGIN OK!--->\r\n");
				}
			}
			
			if (eth_buffer[a] != *http_entry[index].hdr_end_pointer++)
			{
				http_entry[index].hdr_end_pointer = rx_header_end;
			}
			
			//Das Headerende wird mit (CR+LF+CR+LF) angezeigt!
			if(*http_entry[index].hdr_end_pointer == 0) 
			{
				//HTTP_DEBUG("<---HEADER ENDE ERREICHT!--->\r\n");
				break;
			}
		}
	}
	
	//Einzelne Postpacket (z.B. bei firefox)
	if(http_entry[index].http_auth && http_entry[index].post == 1)
	{
		for(a = TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
		{	
			//Schaltanweisung finden!
			if (eth_buffer[a] != *http_entry[index].post_ptr++)
			{
				http_entry[index].post_ptr = post_in;
			}
			if(*http_entry[index].post_ptr == 0) 
			{
				steuerung(eth_buffer[a+1]); //in rs485
				
				http_entry[index].post_ptr = post_in;
				//Schaltanweisung wurde gefunden
			}
		
			//Submit schliet die suche ab!
			if (eth_buffer[a] != *http_entry[index].post_ready_ptr++)
			{
				http_entry[index].post_ready_ptr = post_ready;
			}
			if(*http_entry[index].post_ready_ptr == 0) 
			{
				http_entry[index].post = 0;
				break;
				//Submit gefunden
			}
		}
		//warten bis Steuerbefehl weg ist
		doreload = 1;
		
		
	}
	
	//Welche datei wird angefordert? Wird diese in der Flashspeichertabelle gefunden?
	unsigned char page_index = 0;
	
	if (!http_entry[index].new_page_pointer)
	{
		//Nenninger get Steuerung
		for(a = TCP_DATA_START_VAR;a<(TCP_DATA_END_VAR);a++)
		{
			if (eth_buffer[a] == '?')
			{
				for(c=0;c<10;c++){
					steuerbefehl[0+c]=eth_buffer[a+c];
					if (eth_buffer[a+c] == '\r'){
						steuerbefehl[0+c]='\0';
						break;
					}
				}
				if(strcasestr(steuerbefehl,steuerbefehlstart)!=0){
					steuerung(steuerbefehl[4]); //in rs485
					
				}
			}
			//HTTP_DEBUG("%c",eth_buffer[a]);
		}
		
		
		for(a = TCP_DATA_START_VAR+5;a<(TCP_DATA_END_VAR);a++)
		{
			if (eth_buffer[a] == '\r')
			{
				eth_buffer[a] = '\0';
				break;
			}
		}
	
		// Initialize pointer to avoid problems when communcation is not finished after webpage transmssion
		http_entry[index].new_page_pointer = 0;

		while(WEBPAGE_TABLE[page_index].filename)
		{
			if (strcasestr((char*)&eth_buffer[TCP_DATA_START_VAR],WEBPAGE_TABLE[page_index].filename)!=0) 
				{
					//HTTP_DEBUG("\r\n\r\nDatei gefunden: ");
					//HTTP_DEBUG("%s",(char*)WEBPAGE_TABLE[page_index].filename);
					//HTTP_DEBUG("<----------------\r\n\r\n");	
					
					if (strcasestr(WEBPAGE_TABLE[page_index].filename,".jpg")!=0)
					{
						http_entry[index].http_header_type = IMAGE_JPEG;
					}
					else if (strcasestr(WEBPAGE_TABLE[page_index].filename,".gif")!=0)
					{
						http_entry[index].http_header_type = IMAGE_GIF;
					}	
					else if (strcasestr(WEBPAGE_TABLE[page_index].filename,".htm")!=0)
					{
						http_entry[index].http_header_type = TEXT_HTML;	
					}
					else if (strcasestr(WEBPAGE_TABLE[page_index].filename,".css")!=0)
					{
						http_entry[index].http_header_type = TEXT_CSS;	
					}
					else
					{
						http_entry[index].http_header_type = TEXT_PLAIN;
					}
					
					http_entry[index].new_page_pointer = WEBPAGE_TABLE[page_index].page_pointer;
					break;
				}
			page_index++;
		}
	}

	//Wurde das Ende vom Header nicht erreicht
	//kommen noch weitere Stcke vom Header!
	if ((*http_entry[index].hdr_end_pointer != 0) || (http_entry[index].post == 1))
	{
		//Der Empfang wird Quitiert und es wird auf weiteres Headerstck gewartet
		tcp_entry[index].status =  ACK_FLAG;
		create_new_tcp_packet(0,index);
		//Warten auf weitere Headerpackete
		tcp_entry[index].app_status = 1;
		return;
	}	
	
	//Wurde das Passwort in den ganzen Headerpacketen gefunden?
	//Wenn nicht dann ausfhren und Passwort anfordern!
	if((!http_entry[index].http_auth) && tcp_entry[index].status&PSH_FLAG)
	{	
		//HTTP_AUTH_Header senden!
		http_entry[index].new_page_pointer = Page0;
		memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header2,(sizeof(http_header2)-1));
		tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
		create_new_tcp_packet((sizeof(http_header2)-1),index);
		tcp_entry[index].app_status = 2;
		return;
	}
	
	//Standart INDEX.HTM Seite wenn keine andere gefunden wurde
	if (!http_entry[index].new_page_pointer)
	{
		//Besucher Counter
		//var_array[MAX_VAR_ARRAY-1]++;
		
		http_entry[index].new_page_pointer = Page1;
		http_entry[index].http_header_type = TEXT_HTML;
	}	
	
	tcp_entry[index].app_status = 2;
	
	//Seiten Header wird gesendet
	switch(http_entry[index].http_header_type){
		case TEXT_PLAIN:
			memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header0,(sizeof(http_header0)-1));
			tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
			create_new_tcp_packet((sizeof(http_header0)-1),index);
		break;
		case TEXT_HTML:
			memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header1,(sizeof(http_header1)-1));
			tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
			create_new_tcp_packet((sizeof(http_header1)-1),index);
		break;
		case IMAGE_JPEG:
			memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header3,(sizeof(http_header3)-1));
			tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
			create_new_tcp_packet((sizeof(http_header3)-1),index);
		break;
		case IMAGE_GIF:
			memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header4,(sizeof(http_header4)-1));
			tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
			create_new_tcp_packet((sizeof(http_header4)-1),index);
		break;
		case TEXT_CSS:
			memcpy_P((char*)&eth_buffer[TCP_DATA_START_VAR],http_header5,(sizeof(http_header5)-1));
			tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
			create_new_tcp_packet((sizeof(http_header5)-1),index);
		break;
	}
	return;
}

//----------------------------------------------------------------------------
//Daten Packete an Client schicken
void httpd_data_send (unsigned char index)
{	
	unsigned int a;
	unsigned char str_len;
	
	char var_conversion_buffer[CONVERSION_BUFFER_LEN];
	
	void ftext (char c){
	switch(c){
		case 0:
			memcpy_P(var_conversion_buffer,ft0,CONVERSION_BUFFER_LEN);
			break;
		case 1:
			memcpy_P(var_conversion_buffer,ft1,CONVERSION_BUFFER_LEN);
			break;
		case 2:
			memcpy_P(var_conversion_buffer,ft2,CONVERSION_BUFFER_LEN);
			break;
		case 3:
			memcpy_P(var_conversion_buffer,ft3,CONVERSION_BUFFER_LEN);
			break;
		case 4:
			memcpy_P(var_conversion_buffer,ft4,CONVERSION_BUFFER_LEN);
			break;
		case 5:
			memcpy_P(var_conversion_buffer,ft5,CONVERSION_BUFFER_LEN);
			break;
		case 6:
			memcpy_P(var_conversion_buffer,ft6,CONVERSION_BUFFER_LEN);
			break;
		case 7:
			memcpy_P(var_conversion_buffer,ft7,CONVERSION_BUFFER_LEN);
			break;
		case 8:
			memcpy_P(var_conversion_buffer,ft8,CONVERSION_BUFFER_LEN);
			break;
		case 9:
			memcpy_P(var_conversion_buffer,ft9,CONVERSION_BUFFER_LEN);
			break;
		case 10: case 13:
			memcpy_P(var_conversion_buffer,ft10,CONVERSION_BUFFER_LEN);
			break;
		case 11:
			memcpy_P(var_conversion_buffer,ft11,CONVERSION_BUFFER_LEN);
			break;
		case 12:
			memcpy_P(var_conversion_buffer,ft12,CONVERSION_BUFFER_LEN);
			break;
			
		}
	}
	
	void tortext (char c){
	switch(c){
		case 0:
			memcpy_P(var_conversion_buffer,tort0,CONVERSION_BUFFER_LEN);
			break;
		case 1:
			memcpy_P(var_conversion_buffer,tort1,CONVERSION_BUFFER_LEN);
			break;
		case 2:
			memcpy_P(var_conversion_buffer,tort2,CONVERSION_BUFFER_LEN);
			break;
		case 3:
			memcpy_P(var_conversion_buffer,tort3,CONVERSION_BUFFER_LEN);
			break;
		case 4:
			memcpy_P(var_conversion_buffer,tort4,CONVERSION_BUFFER_LEN);
			break;
		case 5:
			memcpy_P(var_conversion_buffer,tort5,CONVERSION_BUFFER_LEN);
			break;
		case 6:
			memcpy_P(var_conversion_buffer,tort6,CONVERSION_BUFFER_LEN);
			break;
		case 7:
			memcpy_P(var_conversion_buffer,tort7,CONVERSION_BUFFER_LEN);
			break;
		case 8:
			memcpy_P(var_conversion_buffer,tort8,CONVERSION_BUFFER_LEN);
			break;
		case 9:
			memcpy_P(var_conversion_buffer,tort9,CONVERSION_BUFFER_LEN);
			break;
		case 10:
			memcpy_P(var_conversion_buffer,tort10,CONVERSION_BUFFER_LEN);
			break;	
		}
	}

	
	//Passwort wurde im Header nicht gefunden
	if(!http_entry[index].http_auth)
	{
		http_entry[index].new_page_pointer = Page0;
		#if USE_CAM
		http_entry[index].cam = 0;
		#endif //USE_CAM
	}
	
	//kein Packet empfangen Retransmission des alten Packetes
	if (tcp_entry[index].status == 0) 
	{
		http_entry[index].new_page_pointer = http_entry[index].old_page_pointer;
	}
	http_entry[index].old_page_pointer = http_entry[index].new_page_pointer;

	for (a = 0;a<(MTU_SIZE-(TCP_DATA_START)-150);a++)
	{
		unsigned char b;
		b = pgm_read_byte(http_entry[index].new_page_pointer++);
		eth_buffer[TCP_DATA_START + a] = b;
		
		//Mssen Variablen ins Packet eingesetzt werden? ===> %VA@00 bis %VA@09
		if (b == '%')
		{
			/*if (strncasecmp_P("VA@",http_entry[index].new_page_pointer,3)==0)
			{	
				b = (pgm_read_byte(http_entry[index].new_page_pointer+3)-48)*10;
				b +=(pgm_read_byte(http_entry[index].new_page_pointer+4)-48);	
				itoa (var_array[b],var_conversion_buffer,10);
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a = a + (str_len-1);
				http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+5;
			}*/
			
			if (strncasecmp_P("EG@",http_entry[index].new_page_pointer,3)==0)
			{	
				b = (pgm_read_byte(http_entry[index].new_page_pointer+3)-48)*10;
				b +=(pgm_read_byte(http_entry[index].new_page_pointer+4)-48);	
				switch(b){
				case 0:
				    ftext(eg.funktion0);
					break;
				case 1:
					ftext(eg.funktion1);
					break;
				case 2:
					ftext(eg.funktion2);
					break;
				case 3:
					ftext(eg.funktion3);
					break;
				case 4:
					ftext(eg.funktion4);
					break;
				case 5:
					ftext(eg.funktion5);
					break;
				case 6:
					ftext(eg.funktion6);
					break;
				case 7:
					if((eg.funktion7==0)|(eg.funktion7==3)|(eg.funktion7==5)){
						memcpy_P(var_conversion_buffer,PSTR("ledo.gif"),CONVERSION_BUFFER_LEN);
					}else{
						memcpy_P(var_conversion_buffer,PSTR("ledg.gif"),CONVERSION_BUFFER_LEN);
					}
					break;
				case 8:
					itoa (eg.helligkeit_ist,var_conversion_buffer,10);
					break;
				case 9:
					if(eg.urlaub==1){
						memcpy_P(var_conversion_buffer,  urlaub1,CONVERSION_BUFFER_LEN);
					}else{
						memcpy_P(var_conversion_buffer,  urlaub0,CONVERSION_BUFFER_LEN);
					}
					break;
				case 10:
					itoa (eg.helligkeit_soll,var_conversion_buffer,10);
					break;
				case 11:
					itoa (eg.helligkeit_sonne,var_conversion_buffer,10);
					break;
				case 12:
					itoa (eg.temperatur_ist,var_conversion_buffer,10);
					break;
				case 13:
					if(eg.automatik==1){
						memcpy_P(var_conversion_buffer,  automatik1,CONVERSION_BUFFER_LEN);
					}else{
						memcpy_P(var_conversion_buffer,  automatik0,CONVERSION_BUFFER_LEN);
					}
					break;
				
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a = a + (str_len-1);
				http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+5;
			}
			
			if (strncasecmp_P("OG@",http_entry[index].new_page_pointer,3)==0)
			{	
				b = (pgm_read_byte(http_entry[index].new_page_pointer+3)-48)*10;
				b +=(pgm_read_byte(http_entry[index].new_page_pointer+4)-48);	
				switch(b){
				case 0:
				    ftext(og.funktion0);
					break;
				case 1:
					ftext(og.funktion1);
					break;
				case 2:
					ftext(og.funktion2);
					break;
				case 3:
					ftext(og.funktion3);
					break;
				case 4:
					ftext(og.funktion4);
					break;
				case 5:
					ftext(og.funktion5);
					break;
				case 6:
					ftext(og.funktion6);
					break;
				case 7:
					ftext(og.funktion7);
					break;
				case 8:
					itoa (og.helligkeit_ist,var_conversion_buffer,10);
					break;
				case 9:
					if(og.urlaub==1){
						memcpy_P(var_conversion_buffer,  urlaub1,CONVERSION_BUFFER_LEN);
					}else{
						memcpy_P(var_conversion_buffer,  urlaub0,CONVERSION_BUFFER_LEN);
					}
					break;
				case 10:
					itoa (og.helligkeit_soll,var_conversion_buffer,10);
					break;
				case 11:
					itoa (og.helligkeit_sonne,var_conversion_buffer,10);
					break;
				case 12:
					itoa (og.temperatur_ist,var_conversion_buffer,10);
					break;
				case 13:
					if(og.automatik==1){
						memcpy_P(var_conversion_buffer,  automatik1,CONVERSION_BUFFER_LEN);
					}else{
						memcpy_P(var_conversion_buffer,  automatik0,CONVERSION_BUFFER_LEN);
					}
					break;
				
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a = a + (str_len-1);
				http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+5;
			}
			
			if (strncasecmp_P("TOR@",http_entry[index].new_page_pointer,4)==0)
			{	
				b = (pgm_read_byte(http_entry[index].new_page_pointer+4)-48)*10;
				b +=(pgm_read_byte(http_entry[index].new_page_pointer+5)-48);	
				switch(b){
					case 0:
						tortext(tor.ls);
						break;
					case 1:
						tortext(tor.geh);
						break;
					case 2:
						tortext(tor.stand);
						break;
					case 3:
						tortext(tor.steuerung);
						break;
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a = a + (str_len-1);
				http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+6;
			}
			if (strncasecmp_P("SM1@",http_entry[index].new_page_pointer,4)==0)
			{	
				b = (pgm_read_byte(http_entry[index].new_page_pointer+4)-48)*10;
				b +=(pgm_read_byte(http_entry[index].new_page_pointer+5)-48);	
				switch(b){
					case 1:
						if((sm1.ausgang & 0x08)==0x08){
							memcpy_P(var_conversion_buffer,PSTR("ledg.gif"),CONVERSION_BUFFER_LEN);
						}else{
							memcpy_P(var_conversion_buffer,PSTR("ledo.gif"),CONVERSION_BUFFER_LEN);
						}
						break;
					case 2:
						if((sm1.ausgang & 0x10)==0x10){
							memcpy_P(var_conversion_buffer,PSTR("ledg.gif"),CONVERSION_BUFFER_LEN);
						}else{
							memcpy_P(var_conversion_buffer,PSTR("ledo.gif"),CONVERSION_BUFFER_LEN);
						}
						break;
					case 3:
						if((sm1.ausgang & 0x20)==0x20){
							memcpy_P(var_conversion_buffer,PSTR("ledg.gif"),CONVERSION_BUFFER_LEN);
						}else{
							memcpy_P(var_conversion_buffer,PSTR("ledo.gif"),CONVERSION_BUFFER_LEN);
						}
						break;
					case 4:
						if((sm1.ausgang & 0x40)==0x40){
							memcpy_P(var_conversion_buffer,PSTR("ledg.gif"),CONVERSION_BUFFER_LEN);
						}else{
							memcpy_P(var_conversion_buffer,PSTR("ledo.gif"),CONVERSION_BUFFER_LEN);
						}
						break;
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a = a + (str_len-1);
				http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+6;
			}
			
			//reload der seite
            if (strncasecmp_P("RELOAD",http_entry[index].new_page_pointer,6)==0)
            {
				unsigned char len;
				if (doreload==1)
                {
                    b =(pgm_read_byte(http_entry[index].new_page_pointer+6)-48);
					switch(b){
						case 2:
							len = (sizeof(http_reloadeg)-1);
							memcpy_P(var_conversion_buffer,http_reloadeg,len);
						break;
						case 3:
							len = (sizeof(http_reloadog)-1);
							memcpy_P(var_conversion_buffer,http_reloadog,len);
						break;
						case 4:
							len = (sizeof(http_reloadst)-1);
							memcpy_P(var_conversion_buffer,http_reloadst,len);
						break;
						default:
							len = CONVERSION_BUFFER_LEN;
							memcpy_P(var_conversion_buffer,PSTR(""),CONVERSION_BUFFER_LEN);
						break;
					
					}
					
					doreload = 0;
                }
                else
                {
					//telnet_write("Relaod0\r\n");
					len = CONVERSION_BUFFER_LEN;
					memcpy_P(var_conversion_buffer,PSTR(""),CONVERSION_BUFFER_LEN);
                }
                str_len = strnlen(var_conversion_buffer,len);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a = a + (str_len-1);
				http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+7;
            }
			
            #if USE_NTP
            //Zeit in Webseite einfgen
            if (strncasecmp_P("TIME",http_entry[index].new_page_pointer,4)==0)
            {
                if (ntp_state == NTP_STATE_REQ_ERR)
                {
                    strcpy("dstr","-");
                }
                else
                {
                    ntp_struct dt;
                    decode_time(time, &dt);
                    sprintf_P(dstr, PSTR("%s, %s"), dt.datestr, dt.timestr);
                }
                str_len = strnlen(dstr,24);
                memmove(&eth_buffer[TCP_DATA_START+a],dstr,str_len);
                a += str_len - 1;
                http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+4;
            }
            #endif
			//Temperatur in Webseite einfgen
            if (strncasecmp_P("TEMP",http_entry[index].new_page_pointer,4)==0)
            {
                itoa(sensor.temperatur-107,dstr,10);
				str_len = strnlen(dstr,24);
                memmove(&eth_buffer[TCP_DATA_START+a],dstr,str_len);
                a += str_len - 1;
                http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+4;
            }
			//Helligkeit in Webseite einfgen
            if (strncasecmp_P("HELL",http_entry[index].new_page_pointer,4)==0)
            {
                itoa(sensor.helligkeit,dstr,10);
				str_len = strnlen(dstr,24);
                memmove(&eth_buffer[TCP_DATA_START+a],dstr,str_len);
                a += str_len - 1;
                http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+4;
            }
			
			//Steuerbefehl
            if (strncasecmp_P("SB",http_entry[index].new_page_pointer,2)==0)
            {
                str_len = strnlen(steuerbefehl,6);
                memmove(&eth_buffer[TCP_DATA_START+a],steuerbefehl,str_len);
                a += str_len - 1;
                http_entry[index].new_page_pointer=http_entry[index].new_page_pointer+2;
            }
            
			//Einsetzen des Port Status %PORTxy durch "checked" wenn Portx.Piny = 1
			//x: A..G  y: 0..7 
			if (strncasecmp_P("PORT",http_entry[index].new_page_pointer,4)==0)
			{
				unsigned char pin  = (pgm_read_byte(http_entry[index].new_page_pointer+5)-48);	
				b = 0;
				switch(pgm_read_byte(http_entry[index].new_page_pointer+4))
				{
					case 'A':
						b = (PORTA & (1<<pin));
						break;
					case 'B':
						b = (PORTB & (1<<pin));
						break;
					case 'C':
						b = (PORTC & (1<<pin));
						break;
					case 'D':
						b = (PORTD & (1<<pin));
						break; 
				}
				
				if(b)
				{
					strcpy_P(var_conversion_buffer, PSTR("checked"));
				}
				else
				{
					strcpy_P(var_conversion_buffer, PSTR("\0"));
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a += str_len-1;
				http_entry[index].new_page_pointer = http_entry[index].new_page_pointer+6;
			}
			
			//Einsetzen des Port Status %PORTxy durch LED on off wenn Portx.Piny = 1
			//x: A..G  y: 0..7 
			if (strncasecmp_P("AUSG",http_entry[index].new_page_pointer,4)==0)
			{
				unsigned char pin  = (pgm_read_byte(http_entry[index].new_page_pointer+5)-48);	
				b = 0;
				switch(pgm_read_byte(http_entry[index].new_page_pointer+4))
				{
					case 'A':
						b = (PORTA & (1<<pin));
						break;
					case 'B':
						b = (PORTB & (1<<pin));
						break;
					case 'C':
						b = (PORTC & (1<<pin));
						break;
					case 'D':
						b = (PORTD & (1<<pin));
						break; 
				}
				
				if(b)
				{
					strcpy_P(var_conversion_buffer, PSTR("ledg.gif"));
				}
				else
				{
					strcpy_P(var_conversion_buffer, PSTR("ledo.gif"));
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a += str_len-1;
				http_entry[index].new_page_pointer = http_entry[index].new_page_pointer+6;
			}

			
			//Einsetzen des Pin Status %PI@xy bis %PI@xy durch "ledon" oder "ledoff"
			//x = 0 : PINA / x = 1 : PINB / x = 2 : PINC / x = 3 : PIND
			if (strncasecmp_P("PIN",http_entry[index].new_page_pointer,3)==0)
			{
				unsigned char pin  = (pgm_read_byte(http_entry[index].new_page_pointer+4)-48);	
				b = 0;
				switch(pgm_read_byte(http_entry[index].new_page_pointer+3))
				{
					case 'A':
						b = (PINA & (1<<pin));
						break;
					case 'B':
						b = (PINB & (1<<pin));
						break;
					case 'C':
						b = ((PINC ^ 0xff) & (1<<pin));
						break;
					case 'D':
						b = (PIND & (1<<pin));
						break;    
				}
				
				if(b)
				{
					strcpy_P(var_conversion_buffer, PSTR("ledg.gif"));
				}
				else
				{
					strcpy_P(var_conversion_buffer, PSTR("ledr.gif"));
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a += str_len-1;
				http_entry[index].new_page_pointer = http_entry[index].new_page_pointer+5;
			}
			//Einsetzen des SE Status %SE@xy bis %PI@xy durch "ledon" oder "ledoff"
			if (strncasecmp_P("SE",http_entry[index].new_page_pointer,2)==0)
			{
				b = 0;
				switch(pgm_read_byte(http_entry[index].new_page_pointer+2))
				{
					case '0':
						b = ((sensor.eingaenge ^ 0xff)& (1<<0));
						break;
					case '1':
						b = ((sensor.eingaenge ^ 0xff)& (1<<1));
						break;
				}
				
				if(b)
				{
					strcpy_P(var_conversion_buffer, PSTR("ledg.gif"));
				}
				else
				{
					strcpy_P(var_conversion_buffer, PSTR("ledr.gif"));
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a += str_len-1;
				http_entry[index].new_page_pointer = http_entry[index].new_page_pointer+3;
			}
			//Einsetzen des DEV Status %DEVX bis %DEVy durch "ledon" oder "ledoff"
			//x = 0 : PINA / x = 1 : PINB / x = 2 : PINC / x = 3 : PIND
			if (strncasecmp_P("DEV",http_entry[index].new_page_pointer,3)==0)
			{
				unsigned char pin  = (pgm_read_byte(http_entry[index].new_page_pointer+3)-48);	
				b = 0;
				b = (devonline & (1<<pin));
				
				if(b)
				{
					strcpy_P(var_conversion_buffer, PSTR("ledg.gif"));
				}
				else
				{
					strcpy_P(var_conversion_buffer, PSTR("ledo.gif"));
				}
				str_len = strnlen(var_conversion_buffer,CONVERSION_BUFFER_LEN);
				memmove(&eth_buffer[TCP_DATA_START+a],var_conversion_buffer,str_len);
				a += str_len-1;
				http_entry[index].new_page_pointer = http_entry[index].new_page_pointer+4;
			}
			//wurde das Ende des Packetes erreicht?
			//Verbindung TCP Port kann beim nchsten ACK geschlossen werden
			//Schleife wird abgebrochen keine Daten mehr!!
			if (strncasecmp_P("END",http_entry[index].new_page_pointer,3)==0)
			{	
				tcp_entry[index].app_status = 0xFFFD;
				steuerbefehl[0]='\0';
				break;
				
			}
		}
	}
	//Erzeugte Packet kann nun gesendet werden!
	tcp_entry[index].status =  ACK_FLAG | PSH_FLAG;
	create_new_tcp_packet(a,index);
	return;
}


